#!/usr/bin/perl

# Program ScrambleText_1_0.cgi

# All rights reserved by RAVN project group and Peter Juel Henrichsen

# -------------- INPUT ---------------- 

read(STDIN,$datax,%ENV{'CONTENT_LENGTH'});
($bound) = $datax=~/^(--+\S+)/;

for (split /$bound\r?\n?/,$datax) {
  /^on\b/mi and /RAVN([WL])SCRAM/ and $method{$1}=1 and next;
  ($t=$_) =~ s!^content-\w.+\r?\n!!gim;
  $txt.=$t if $t=~/[^\s-]/ and $t=~/\S/;
};

$txt =~ s!\n\n+!\n!g;
$txt =~ s!(.*)!&scrwds($1)!meg if $method{'W'}; 
$txt = &scrlin($txt) if $method{'L'};

sub scrwds { join " ",&scram( $_[0]=~/(\S+)/g ) };
sub scrlin { join "\n",&scram( $_[0]=~/^(.+)/gm ) };
sub scram { my(@a) = sort map(rand."\t$_", @_); map(s/^\S+\t// && $_, @a) };

# -------------- OUTPUT ---------------- 

print <<RAVN
Content-type: text/html

<html>
<head>
</head>

<body bgcolor='#99FFFF'>

<h2>RAVN text scrambler</h2>
<i>Updated 7.5.2019</i>
<hr><pre>$txt</pre><hr>

<form action="https://lab.homunculus.dk/cgi-bin/Ravn/ScrambleText_1_0.cgi" 
      method=POST enctype="multipart/form-data">
  <b>Three ways to supply text:</b><br>
  <ol><li>Select a text file for upload  
  <input type="file" name="RAVNLIST" accept=".txt">
 
</li>
      <li>Insert a text in the area below</li>

  <li>Do both (texts are conjoined and treated as one)</li>
</ol>
  <textarea name="RAVNTXT" rows=15 cols=60></textarea><p>

  <b>Scrambling methods:</b>
  Each line is word-scrambled <input type="checkbox" name="RAVNWSCRAM" checked>
  Text is line-scrambled <input type="checkbox" name="RAVNLSCRAM" checked>
  <p>

  Press <input value="SCRAMBLE" type=submit>

</form>

</body>
</html>

RAVN
;


