#!/usr/bin/perl

# perl PushPrompt_1_2.cgi  - (from parrot_6.cgi)  - runs on server

#   Asks for prompt file (*.txt) from local client
#   Prompt file can be a simple txt-file with lines of text (ISO) to be read
#   Optionally, text lines can be /^TEXT\tFEAS$/, FEAS --> FEA=VAL;FEA=VAL ..
#     FEA         VAL
#     fcol        red, green, ..., black (default)
#     fsize       h1, h2, ..., h3 (default)
#     clicktext   START, ..., <smiley> (default)

# ------------------- defaults, settings and init ---------------------

#    --- session defs ---

$thisver = 'PushPrompt_1_2.cgi';
$url = 'https://lab.homunculus.dk/cgi-bin/Ravn';
$updated = '5-2-21'; 
$bgcol = 'ddeeff';
$Ravn_stamp = 'RavnPush12_';

#    --- prompt defs (defaults) ---

$initclicktext = 'CLICK TO START';
$finalclicktext = 'CLICK TO END';
$redotext = "<p style='color:red'>SAY IT AGAIN:</p>";

$hellotext = '';    # hello to reader ('no text' is OK)
$clicktext = '<h1>&#128522;</h1>'; # OK button (in pfile: ..;clicktext=[GO];..)
$failtext = '<h1>&#128540</h1>';  # err button (in pfile: ..;clicktext=[GO];..)
$byetext = '<h1>&#128526;</h1>';    # goodbye to reader
$fsize = 'h3';             # fontsize for prompts (in pfile: ..;fsize=h2;..)
$fcol = 'black';           # fontsize for prompts (in pfile: ..;fcol=red;..)

# ------------------- parse input ---------------------

($Q = $ENV{'QUERY_STRING'}) =~ s/\%(..)/pack('C',hex($1))/eg;
($PIX) = $Q=~/\bPIX=(\d+)/;
($PPROD) = $Q=~/\bPPROD=(\d+)/;
($PTBEG) = $Q=~/\bPTBEG=(\d+\.\d+)/;
($filename) = $Q=~/\bFILENAME=([\w\.]+)/;
($STATUS) = $Q=~/\bSTATUS=(\w+)/;
$Q=~/\bCLICKTEXT=([^&]+)/ and $clicktext=$1;
$Q=~/\bFMETA=([^&]+)/ and $fmeta=$1;

$textcomment = $Q=~/\bSTATUS=fail\b/? $redotext: '';

read(STDIN,$D,$ENV{'CONTENT_LENGTH'});
($bound) = $D=~/^(--+\S+)/m;
$D=~/\bfilename=['"]([^'"]*)['"]/i and $filename=$1;
for (split /$bound-*/,$D) {
  ($name)=/\bname=['"](.*?)['"]/i;
  $content=$_;
  $content=~s/^Content.+//mig; 
  $content=~s!\s*\n\s*!\n!g; $content=~s/^\n|\n$//g;
  $D{$name}=$content;
};

$PFILE = $D{'PFILE'}=~/(\d+_\d+)/? $1: $Q=~/\bPFILE=(\d+_\d+)/? $1: '';
  
if ($D{'PTXT'}=~/\S/) {
  @rawprom = split(/\n+/,$D{'PTXT'}); $PFILE = "".time."_$$";
  open(P,">/tmp/${Ravn_stamp}prompts_$PFILE.txt"); print P join("\n",@rawprom);
  close(P);
} elsif ($PFILE) {
  open(P,"/tmp/${Ravn_stamp}prompts_$PFILE.txt") and @rawprom = <P>;
};

@prompts = ($hellotext); 
@fea = ("fcol=red;clicktext=$initclicktext");
for (@rawprom) { chomp; ($p,$f)=split /\t+/; push(@prompts,$p); push(@fea,$f) };
push @prompts,$byetext; push @fea,"fcol=red;clicktext=$finalclicktext";

# ------------------- write output ---------------------

if ($PFILE and $PTBEG and $PPROD) {
  open(P,">>/tmp/${Ravn_stamp}productions_$PFILE.txt");
  print P "$filename\t".&rnd($PTBEG,3)."\t$STATUS\t$PPROD\t$prompts[$PPROD]\t[$fmeta]\n";
  close(P);
};
$fmeta='';

  # $Dx = "<hr><pre>HERFRA:$D:HERTIL</pre><p><hr>\n";

if ($STATUS eq 'EXIT') {
  open(P,"/tmp/${Ravn_stamp}productions_$PFILE.txt");
  my $txt = join '',<P>; 
  
  print "Content-type: text/plain\n\n$txt";
}
else {
  print
    "Content-type: text/html\n\n<html>\n<head></head>\n".
    "<body bgcolor=#$bgcol><h1>RAVN reading session guide</h1>$Dx\n".
    "<p>".
      ($#rawprom<0? &initpage: $PIX<=$#prompts? &promptpage($PIX): &exitpage).
     "\n</body>\n".
  "</html>";
}

# ------------------- subs -----------------

sub rnd {sprintf "%.$_[1]"."f", $_[0]};

sub initpage {
  use Time::HiRes qw(gettimeofday); my $T = gettimeofday;

  <<RAVENCLAW
    <i>Updated $updated - time now: $T</i><hr><p>
    <hr>
    <form action='$url/$thisver?PIX=0&PFILE=$PFILE' method=POST
      enctype='multipart/form-data'>
  Insert PROMPTFILE (ISO txt): <input type='file' name='PTXT' accept='.txt'>
   <p>
  or insert a valid file id: <input type='text' size=20 name='PFILE'>
   <p>
   <input type='submit' value='BEGIN READING SESSION'><p><hr>
  </form>
RAVENCLAW
};

sub promptpage {
  my($this,$next,$prev); $this=$next=$prev=$_[0];  $next++; $prev -= $prev>0;

  use Time::HiRes qw(gettimeofday);
  $TBEG = gettimeofday;

  my($urlfea) =
    "$thisver?PFILE=$PFILE&PTBEG=$TBEG&FILENAME=$filename&PPROD=$this";

  for (split /;/,$fea[$this]) {/(\w+)=(.+)/ and $$1=$2};

  <<RAVNUR
  <table border=1 style='width:100%'>
   <tr adjust=center>
    
    <th style='width:100'>
      <a href='$urlfea&PIX=$next&STATUS=OK&FMETA=$fmeta'><h2>
        $clicktext</h2></a>($this of $#prompts)</th>
      <th>$textcomment
        <$fsize><p style='color:$fcol'>$prompts[$this]</p></$fsize>
    </th>
  </tr>
  </table>
  <p>
<a href='$urlfea&PIX=$this&STATUS=fail&FMETA=$fmeta'>$failtext</a>
RAVNUR
};

sub exitpage {
  use Time::HiRes qw(gettimeofday); my $T = gettimeofday;
  open(P,"/tmp/${Ravn_stamp}productions_$PFILE.txt");
  my $txt = join '',<P>; 
  
  <<STORK
  <hr>
  <a href='$thisver?STATUS=EXIT&PFILE=$PFILE'>DOWNLOAD DATA AS TABLE</a>
  <pre>$txt</pre>
  <hr>
STORK
};

# ------------------- the end ---------------------
